/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class WithParam
extends Instruction {
    private QName _name;
    private Expression _select;

    WithParam() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("with-param " + this._name);
        if (this._select != null) {
            this.indent(indent + 4);
            Util.println("select " + this._select.toString());
        }
        this.displayContents(indent + 4);
    }

    public void parseContents(Parser parser2) {
        String name = this.getAttribute("name");
        if (name.length() > 0) {
            this._name = parser2.getQName(name);
        } else {
            this.reportError(this, parser2, 16, "name");
        }
        String select = this.getAttribute("select");
        if (select.length() > 0) {
            this._select = parser2.parseExpression(this, "select", null);
        }
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._select != null) {
            Type tselect = this._select.typeCheck(stable);
            if (!(tselect instanceof ReferenceType)) {
                this._select = new CastExpr(this._select, Type.Reference);
            }
        } else {
            this.typeCheckContents(stable);
        }
        return Type.Void;
    }

    public void translateValue(ClassGenerator classGen, MethodGenerator methodGen) {
        if (this._select != null) {
            this._select.translate(classGen, methodGen);
            this._select.startResetIterator(classGen, methodGen);
        } else if (this.hasContents()) {
            this.compileResultTree(classGen, methodGen);
        } else {
            ConstantPoolGen cpg = classGen.getConstantPool();
            InstructionList il = methodGen.getInstructionList();
            il.append(new PUSH(cpg, ""));
        }
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        String name = Util.escape(this._name.getLocalPart());
        il.append(classGen.loadTranslet());
        il.append(new PUSH(cpg, name));
        this.translateValue(classGen, methodGen);
        il.append(new PUSH(cpg, false));
        il.append(new INVOKEVIRTUAL(cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "addParameter", "(Ljava/lang/String;Ljava/lang/Object;Z)Ljava/lang/Object;")));
        il.append(InstructionConstants.POP);
    }
}

